/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xobj;

import uk.co.demon.obelisk.xobj.Expr;
import uk.co.demon.obelisk.xobj.Section;
import uk.co.demon.obelisk.xobj.SectionMap;
import uk.co.demon.obelisk.xobj.SymbolMap;

public final class Value
extends Expr {
    private final Section section;
    private final long value;

    public Value(Section section, long value) {
        this.section = section;
        this.value = value;
    }

    public boolean isAbsolute() {
        return this.section == null;
    }

    public boolean isExternal(Section section) {
        return section != this.section;
    }

    public Section getSection() {
        return this.section;
    }

    public long getValue() {
        return this.value;
    }

    public long resolve(SectionMap sections, SymbolMap symbols) {
        if (this.section == null || sections == null && symbols == null) {
            return this.value;
        }
        return sections.baseAddressOf(this.section) + this.value;
    }

    public String toString() {
        if (this.section != null) {
            return "<val sect='" + this.section.getName() + "'>" + this.value + "</val>";
        }
        return "<val>" + this.value + "</val>";
    }
}

